<?php
ob_start();
include 'include/header.php';
include '../config/conn.php';

$admin_id = $_SESSION['user_id'];
$success = '';
$error = '';

// Handle leave approval/rejection via AJAX
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json');
    
    $leave_id = intval($_POST['leave_id']);
    $action = mysqli_real_escape_string($conn, $_POST['action']);
    $admin_notes = mysqli_real_escape_string($conn, $_POST['admin_notes'] ?? '');

    // Get leave details first
    $leave_query = "SELECT * FROM leave_applications WHERE id = $leave_id";
    $leave_result = mysqli_query($conn, $leave_query);
    $leave = mysqli_fetch_assoc($leave_result);

    if (!$leave) {
        echo json_encode(['success' => false, 'message' => 'Leave application not found.']);
        exit();
    }

    if ($action === 'approve') {
        $update_query = "UPDATE leave_applications 
                         SET status = 'approved', admin_notes = '$admin_notes', 
                             reviewed_at = NOW(), reviewed_by = $admin_id
                         WHERE id = $leave_id";
    } elseif ($action === 'reject') {
        $update_query = "UPDATE leave_applications 
                         SET status = 'rejected', admin_notes = '$admin_notes', 
                             reviewed_at = NOW(), reviewed_by = $admin_id
                         WHERE id = $leave_id";
    }

    if (isset($update_query) && mysqli_query($conn, $update_query)) {
        echo json_encode(['success' => true, 'message' => 'Leave updated successfully!']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error updating leave: ' . mysqli_error($conn)]);
    }

    exit();
}

// Get all teachers for filter dropdown
$teachers_query = "SELECT id, full_name FROM users WHERE role = 'teacher'";
$teachers_result = mysqli_query($conn, $teachers_query);
$teachers = [];
while ($teacher = mysqli_fetch_assoc($teachers_result)) {
    $teachers[] = $teacher;
}

// Filters
$status_filter = isset($_GET['status']) ? mysqli_real_escape_string($conn, $_GET['status']) : 'pending';
$date_filter = isset($_GET['date']) ? mysqli_real_escape_string($conn, $_GET['date']) : '';
$teacher_filter = isset($_GET['teacher']) ? intval($_GET['teacher']) : 0;

// Build conditions
$where_conditions = ["1=1"];
if ($status_filter !== 'all') {
    $where_conditions[] = "la.status = '$status_filter'";
}
if ($date_filter) {
    $where_conditions[] = "la.start_date <= '$date_filter' AND la.end_date >= '$date_filter'";
}
if ($teacher_filter > 0) {
    $where_conditions[] = "la.teacher_id = $teacher_filter";
}
$where_clause = implode(' AND ', $where_conditions);

// Get leave applications with teacher information
$leave_query = "SELECT la.*, 
                       u.full_name as teacher_name, 
                       u.email as teacher_email,
                       lt.type_name as type_name,
                       rev.full_name as reviewed_by_name
                FROM leave_applications la
                LEFT JOIN users u ON la.teacher_id = u.id
                LEFT JOIN leave_types lt ON la.leave_type_id = lt.id
                LEFT JOIN users rev ON la.reviewed_by = rev.id
                WHERE $where_clause
                ORDER BY la.applied_at DESC";
$leave_result = mysqli_query($conn, $leave_query);

$leave_applications = [];
while ($leave = mysqli_fetch_assoc($leave_result)) {
    $leave_applications[] = $leave;
}

// Stats
$stats_query = "SELECT 
                   COUNT(*) as total,
                   SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending,
                   SUM(CASE WHEN status = 'approved' THEN 1 ELSE 0 END) as approved,
                   SUM(CASE WHEN status = 'rejected' THEN 1 ELSE 0 END) as rejected
                FROM leave_applications";
$stats_result = mysqli_query($conn, $stats_query);
$stats = mysqli_fetch_assoc($stats_result);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Leave Management</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .leave-status {
            padding: 0.25rem 0.5rem;
            border-radius: 0.25rem;
            font-size: 0.75rem;
            font-weight: 500;
        }
        .status-pending {
            background-color: #fef3c7;
            color: #92400e;
        }
        .status-approved {
            background-color: #d1fae5;
            color: #065f46;
        }
        .status-rejected {
            background-color: #fee2e2;
            color: #b91c1c;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
        }
        .modal-content {
            background-color: white;
            margin: 10% auto;
            padding: 20px;
            border-radius: 8px;
            width: 90%;
            max-width: 500px;
        }
        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 15px 20px;
            border-radius: 5px;
            z-index: 1001;
            opacity: 0;
            transform: translateY(-20px);
            transition: all 0.3s ease;
        }
        .notification.show {
            opacity: 1;
            transform: translateY(0);
        }
        .notification.success {
            background-color: #d1fae5;
            color: #065f46;
            border: 1px solid #a7f3d0;
        }
        .notification.error {
            background-color: #fee2e2;
            color: #b91c1c;
            border: 1px solid #fecaca;
        }
    </style>
</head>
<body class="bg-gray-100">
    <!-- Notification Container -->
    <div id="notification" class="notification"></div>

    <div class="container mx-auto px-4 py-8">
        <div class="bg-white p-6 rounded-lg shadow">
            <div class="flex justify-between items-center mb-6">
                <h2 class="text-2xl font-bold text-gray-800">Leave Management System</h2>
                <a href="dashboard.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                    <i class="fas fa-arrow-left mr-2"></i> Back to Dashboard
                </a>
            </div>

            <!-- Statistics -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                <div class="bg-white p-4 rounded-lg shadow border-l-4 border-blue-500">
                    <div class="text-2xl font-bold text-gray-800"><?php echo $stats['total']; ?></div>
                    <div class="text-sm text-gray-600">Total Applications</div>
                </div>
                <div class="bg-white p-4 rounded-lg shadow border-l-4 border-yellow-500">
                    <div class="text-2xl font-bold text-gray-800"><?php echo $stats['pending']; ?></div>
                    <div class="text-sm text-gray-600">Pending Review</div>
                </div>
                <div class="bg-white p-4 rounded-lg shadow border-l-4 border-green-500">
                    <div class="text-2xl font-bold text-gray-800"><?php echo $stats['approved']; ?></div>
                    <div class="text-sm text-gray-600">Approved</div>
                </div>
                <div class="bg-white p-4 rounded-lg shadow border-l-4 border-red-500">
                    <div class="text-2xl font-bold text-gray-800"><?php echo $stats['rejected']; ?></div>
                    <div class="text-sm text-gray-600">Rejected</div>
                </div>
            </div>

            <!-- Filters -->
            <div class="bg-gray-50 p-4 rounded-lg mb-6">
                <form method="GET" action="" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                        <select name="status" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="all" <?php echo $status_filter === 'all' ? 'selected' : ''; ?>>All Status</option>
                            <option value="pending" <?php echo $status_filter === 'pending' ? 'selected' : ''; ?>>Pending</option>
                            <option value="approved" <?php echo $status_filter === 'approved' ? 'selected' : ''; ?>>Approved</option>
                            <option value="rejected" <?php echo $status_filter === 'rejected' ? 'selected' : ''; ?>>Rejected</option>
                        </select>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Date</label>
                        <input type="date" name="date" value="<?php echo $date_filter; ?>"
                               class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Teacher</label>
                        <select name="teacher" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="0">All Teachers</option>
                            <?php foreach ($teachers as $teacher): ?>
                                <option value="<?php echo $teacher['id']; ?>" <?php echo $teacher_filter == $teacher['id'] ? 'selected' : ''; ?>>
                                    <?php echo $teacher['full_name']; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="flex items-end space-x-2">
                        <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg h-10">
                            <i class="fas fa-filter mr-2"></i> Apply
                        </button>
                        <a href="admin_leave.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg h-10">
                            <i class="fas fa-times mr-2"></i> Clear
                        </a>
                    </div>
                </form>
            </div>

            <!-- Leave Applications Table -->
            <div class="bg-white rounded-lg shadow overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full">
                        <thead class="bg-gray-200 text-gray-700">
                            <tr>
                                <th class="py-3 px-4 text-left">Teacher</th>
                                <th class="py-3 px-4 text-left">Leave Type</th>
                                <th class="py-3 px-4 text-left">Dates</th>
                                <th class="py-3 px-4 text-left">Days</th>
                                <th class="py-3 px-4 text-left">Status</th>
                                <th class="py-3 px-4 text-left">Applied On</th>
                                <th class="py-3 px-4 text-left">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-600">
                            <?php if (!empty($leave_applications)): ?>
                                <?php foreach ($leave_applications as $leave): ?>
                                    <tr class="border-b border-gray-200 hover:bg-gray-50" id="leave-<?php echo $leave['id']; ?>">
                                        <td class="py-3 px-4">
                                            <div class="font-medium"><?php echo $leave['teacher_name']; ?></div>
                                            <div class="text-xs text-gray-400"><?php echo $leave['teacher_email']; ?></div>
                                        </td>
                                        <td class="py-3 px-4"><?php echo $leave['type_name']; ?></td>
                                        <td class="py-3 px-4">
                                            <?php echo date('M j, Y', strtotime($leave['start_date'])); ?> - 
                                            <?php echo date('M j, Y', strtotime($leave['end_date'])); ?>
                                        </td>
                                        <td class="py-3 px-4 font-medium"><?php echo $leave['working_days']; ?></td>
                                        <td class="py-3 px-4">
                                            <span class="leave-status status-<?php echo $leave['status']; ?>">
                                                <?php echo ucfirst($leave['status']); ?>
                                            </span>
                                        </td>
                                        <td class="py-3 px-4"><?php echo date('M j, Y', strtotime($leave['applied_at'])); ?></td>
                                        <td class="py-3 px-4">
                                            <?php if ($leave['status'] === 'pending'): ?>
                                                <div class="flex space-x-2">
                                                    <button onclick="openModal(<?php echo $leave['id']; ?>, 'approve')" 
                                                            class="bg-green-600 hover:bg-green-700 text-white px-3 py-1 rounded text-sm flex items-center">
                                                        <i class="fas fa-check mr-1"></i> Approve
                                                    </button>
                                                    <button onclick="openModal(<?php echo $leave['id']; ?>, 'reject')" 
                                                            class="bg-red-600 hover:bg-red-700 text-white px-3 py-1 rounded text-sm flex items-center">
                                                        <i class="fas fa-times mr-1"></i> Reject
                                                    </button>
                                                </div>
                                            <?php else: ?>
                                                <div class="text-sm">
                                                    <div>By: <?php echo $leave['reviewed_by_name'] ? $leave['reviewed_by_name'] : 'Admin'; ?></div>
                                                    <?php if ($leave['admin_notes']): ?>
                                                        <div class="text-xs text-gray-500 mt-1">Notes: <?php echo htmlspecialchars($leave['admin_notes']); ?></div>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="7" class="py-8 text-center text-gray-500">
                                        <i class="fas fa-inbox text-4xl mb-2"></i>
                                        <p>No leave applications found.</p>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Pagination (if needed) -->
            <?php if (count($leave_applications) > 0): ?>
                <div class="mt-4 flex justify-between items-center">
                    <div class="text-sm text-gray-600">
                        Showing <?php echo count($leave_applications); ?> applications
                    </div>
                    <div class="flex space-x-2">
                        <button class="bg-gray-600 hover:bg-gray-700 text-white px-3 py-1 rounded text-sm">
                            <i class="fas fa-download mr-1"></i> Export
                        </button>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Action Modal -->
    <div id="actionModal" class="modal">
        <div class="modal-content">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-semibold" id="modalTitle">Approve Leave</h3>
                <button onclick="closeModal()" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <form id="actionForm">
                <input type="hidden" name="leave_id" id="modalLeaveId">
                <input type="hidden" name="action" id="modalAction">
                
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Notes (Optional)</label>
                    <textarea name="admin_notes" rows="3" 
                              class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                              placeholder="Add any notes or comments for the teacher"></textarea>
                </div>
                
                <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-3 mb-4">
                    <h4 class="font-medium text-yellow-800 mb-2">Leave Information</h4>
                    <div id="modalLeaveInfo" class="text-sm text-yellow-700"></div>
                </div>
                
                <div class="flex justify-end space-x-3">
                    <button type="button" onclick="closeModal()" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                        Cancel
                    </button>
                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">
                        Confirm
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
    // Store leave data for modal
    const leaveData = <?php echo json_encode($leave_applications); ?>;

    function openModal(leaveId, action) {
        const leave = leaveData.find(l => l.id == leaveId);
        if (!leave) return;

        document.getElementById('modalLeaveId').value = leaveId;
        document.getElementById('modalAction').value = action;
        document.getElementById('modalTitle').textContent = action === 'approve' ? 'Approve Leave' : 'Reject Leave';
        
        // Populate leave information
        const leaveInfo = `
            <div><strong>Teacher:</strong> ${leave.teacher_name}</div>
            <div><strong>Leave Type:</strong> ${leave.type_name}</div>
            <div><strong>Dates:</strong> ${new Date(leave.start_date).toLocaleDateString()} - ${new Date(leave.end_date).toLocaleDateString()}</div>
            <div><strong>Days:</strong> ${leave.working_days}</div>
            <div><strong>Reason:</strong> ${leave.reason}</div>
        `;
        document.getElementById('modalLeaveInfo').innerHTML = leaveInfo;
        
        document.getElementById('actionModal').style.display = 'block';
    }

    function closeModal() {
        document.getElementById('actionModal').style.display = 'none';
    }

    // Close modal when clicking outside
    window.onclick = function(event) {
        const modal = document.getElementById('actionModal');
        if (event.target === modal) {
            closeModal();
        }
    }

    // Show notification
    function showNotification(message, type) {
        const notification = document.getElementById('notification');
        notification.textContent = message;
        notification.className = `notification ${type} show`;
        
        setTimeout(() => {
            notification.className = 'notification';
        }, 3000);
    }

    // AJAX form submission
    document.getElementById('actionForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const leaveId = formData.get('leave_id');
        const action = formData.get('action');
        
        fetch('admin_leave.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showNotification(data.message, 'success');
                closeModal();
                
                // Update the table row
                const row = document.getElementById(`leave-${leaveId}`);
                if (row) {
                    // Update status
                    const statusCell = row.querySelector('.leave-status');
                    statusCell.textContent = action === 'approve' ? 'Approved' : 'Rejected';
                    statusCell.className = `leave-status status-${action === 'approve' ? 'approved' : 'rejected'}`;
                    
                    // Update actions cell
                    const actionsCell = row.querySelector('td:last-child');
                    actionsCell.innerHTML = `
                        <div class="text-sm">
                            <div>By: <?php echo $_SESSION['full_name'] ?? 'Admin'; ?></div>
                            <div class="text-xs text-gray-500 mt-1">Notes: ${formData.get('admin_notes') || 'None'}</div>
                        </div>
                    `;
                }
            } else {
                showNotification(data.message, 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showNotification('An error occurred. Please try again.', 'error');
        });
    });

    // Auto-refresh every 30 seconds to check for new applications
    setInterval(() => {
        if (document.getElementById('actionModal').style.display === 'none') {
            window.location.reload();
        }
    }, 30000);
    </script>
</body>
</html>

<?php
include 'include/footer.php';
ob_end_flush();