<?php
include 'include/header.php';
include '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$admin_id   = $_SESSION['user_id'];
$admin_name = $_SESSION['user_name'];

$success = '';
$error   = '';

// Function to safely get POST values
function getPostValue($key) {
    return isset($_POST[$key]) ? mysqli_real_escape_string($GLOBALS['conn'], $_POST[$key]) : '';
}

// Function to check if email already exists in users (role = teacher)
function emailExists($email, $conn) {
    $email = mysqli_real_escape_string($conn, $email);
    $sql   = "SELECT id FROM users WHERE email = '$email' AND role = 'teacher'";
    $result = mysqli_query($conn, $sql);
    return mysqli_num_rows($result) > 0;
}

// Function to check if username already exists in users (role = teacher)
function usernameExists($username, $conn) {
    $username = mysqli_real_escape_string($conn, $username);
    $sql   = "SELECT id FROM users WHERE username = '$username' AND role = 'teacher'";
    $result = mysqli_query($conn, $sql);
    return mysqli_num_rows($result) > 0;
}

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Handle form inputs
    $fullName         = getPostValue('fullName');
    $username         = getPostValue('username');
    $password         = getPostValue('password');
    $confirm_password = getPostValue('confirm_password');
    $dob              = getPostValue('dob');
    $gender           = getPostValue('gender');
    $nationality      = getPostValue('nationality');
    $idNumber         = getPostValue('idNumber');
    $address          = getPostValue('address');
    $phone            = getPostValue('phone');
    $email            = getPostValue('email');
    $emergencyContact = getPostValue('emergencyContact');
    $emergencyPhone   = getPostValue('emergencyPhone');
    $hireDate         = getPostValue('hireDate');
    $subject          = getPostValue('subject');
    $classesToTeach   = isset($_POST['classesToTeach']) ? $_POST['classesToTeach'] : [];
    $highestDegree    = getPostValue('highestDegree');
    $university       = getPostValue('university');
    $graduationYear   = getPostValue('graduationYear');
    $experience       = getPostValue('experience');
    $salary           = getPostValue('salary');
    $bankAccount      = getPostValue('bankAccount');
    $bankName         = getPostValue('bankName');
    $medicalConditions = getPostValue('medicalConditions');
    $allergies        = getPostValue('allergies');
    $bloodGroup       = getPostValue('bloodGroup');
    
    // Validate required fields
    if (empty($fullName) || empty($username) || empty($password) || empty($confirm_password) || 
        empty($dob) || empty($gender) || empty($address) || empty($phone) || empty($email) || 
        empty($hireDate) || empty($highestDegree) || empty($university) || 
        empty($graduationYear) || empty($experience) || empty($salary)) {
        $error = "Please fill in all required fields.";
    } 
    elseif ($password !== $confirm_password) {
        $error = "Passwords do not match.";
    }
    elseif (emailExists($email, $conn)) {
        $error = "A teacher with this email address already exists. Please use a different email.";
    }
    elseif (usernameExists($username, $conn)) {
        $error = "Username already exists. Please choose a different username.";
    }
    else {
        // Handle file upload
        $photoPath = '';
        if (isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
            $targetDir = "../uploads/";
            if (!is_dir($targetDir)) {
                mkdir($targetDir, 0777, true);
            }
            
            $fileName = time() . '_' . basename($_FILES['photo']['name']);
            $targetFilePath = $targetDir . $fileName;
            $fileType = pathinfo($targetFilePath, PATHINFO_EXTENSION);
            
            $allowTypes = array('jpg', 'png', 'jpeg', 'gif');
            if (in_array(strtolower($fileType), $allowTypes)) {
                if (move_uploaded_file($_FILES['photo']['tmp_name'], $targetFilePath)) {
                    $photoPath = $fileName; // store only filename, not full path
                }
            }
        }
        
        // Generate a unique teacher ID
        $teacherId = 'TCH' . date('Y') . rand(1000, 9999);
        
        // Hash the password
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        
        // Convert classes array to string
        $classesString = !empty($classesToTeach) ? implode(',', $classesToTeach) : '';
        
        // Insert into DB
        $userSql = "INSERT INTO users (
            username, name, teacher_id, full_name, phone, subjects, grades, hire_date, salary, status, 
            email, password, role, photo, created_at, password_updated_at,
            profile_completion, created_by, updated_by, dob, gender, nationality, id_number, address, 
            emergency_contact, emergency_phone, highest_degree, university, graduation_year, 
            experience, bank_account, bank_name, medical_conditions, allergies, blood_group
        ) VALUES (
            '$username', '$username', '$teacherId', '$fullName', '$phone', '$subject', '$classesString', '$hireDate', 
            '$salary', 'active', '$email', '$hashed_password', 'teacher', '$photoPath', NOW(), NOW(), 
            0, '$admin_id', '$admin_id', '$dob', '$gender', '$nationality', '$idNumber', '$address',
            '$emergencyContact', '$emergencyPhone', '$highestDegree', '$university', '$graduationYear',
            '$experience', '$bankAccount', '$bankName', '$medicalConditions', '$allergies', '$bloodGroup'
        )";

        if (mysqli_query($conn, $userSql)) {
            $success = "Teacher registered successfully! Teacher ID: " . $teacherId . 
                       " (Added by " . $admin_name . " at " . date('Y-m-d H:i:s') . ")";
        } else {
            $error = "Failed to add teacher into users table: " . mysqli_error($conn);
        }

        // Reset form
        echo '<script>
            document.addEventListener("DOMContentLoaded", function() {
                document.getElementById("teacherForm").reset();
                document.getElementById("previewImg").style.display = "none";
                document.querySelector(".photo-preview i").style.display = "block";
            });
        </script>';
    }
}
?>


<style>
    .bg-white {
        background-color: white;
    }
    .p-6 {
        padding: 1.5rem;
    }
   
  
    .text-2xl {
        font-size: 1.5rem;
    }
    .font-bold {
        font-weight: 700;
    }
    .text-gray-800 {
        color: #2d3748;
    }
    .mb-6 {
        margin-bottom: 1.5rem;
    }
    .grid {
        display: grid;
    }
    .grid-cols-1 {
        grid-template-columns: repeat(1, minmax(0, 1fr));
    }
    .md\:grid-cols-2 {
        grid-template-columns: repeat(2, minmax(0, 1fr));
    }
    .gap-6 {
        gap: 1.5rem;
    }
    .block {
        display: block;
    }
    .text-gray-700 {
        color: #4a5568;
    }
    .mb-2 {
        margin-bottom: 0.5rem;
    }
    .w-full {
        width: 100%;
    }
    .px-4 {
        padding-left: 1rem;
        padding-right: 1rem;
    }
    .py-2 {
        padding-top: 0.5rem;
        padding-bottom: 0.5rem;
    }
    .border {
        border-width: 1px;
    }
    
    .focus\:outline-none:focus {
        outline: none;
    }
    .focus\:ring-2:focus {
        box-shadow: 0 0 0 2px rgba(66, 153, 225, 0.5);
    }
    .focus\:ring-blue-500:focus {
        --tw-ring-color: #4299e1;
    }
    .md\:col-span-2 {
        grid-column: span 2 / span 2;
    }
    .flex {
        display: flex;
    }
    .justify-end {
        justify-content: flex-end;
    }
    .space-x-4 > * + * {
        margin-left: 1rem;
    }
    .mt-4 {
        margin-top: 1rem;
    }
    .bg-gray-500 {
        background-color: #6b7280;
    }
    .hover\:bg-gray-600:hover {
        background-color: #4b5563;
    }
    .text-white {
        color: white;
    }
    .px-6 {
        padding-left: 1.5rem;
        padding-right: 1.5rem;
    }
    .py-2 {
        padding-top: 0.5rem;
        padding-bottom: 0.5rem;
    }
    
    .bg-blue-600 {
        background-color: #2563eb;
    }
    .hover\:bg-blue-700:hover {
        background-color: #1d4ed8;
    }
    .relative {
        position: relative;
    }
    .w-32 {
        width: 8rem;
    }
    .h-32 {
        height: 8rem;
    }
    .rounded-full {
        border-radius: 9999px;
    }
    .overflow-hidden {
        overflow: hidden;
    }
    .border-4 {
        border-width: 4px;
    }
    .border-gray-300 {
        border-color: #d1d5db;
    }
  
    .bg-gray-200 {
        background-color: #e5e7eb;
    }
    .hover\:bg-gray-300:hover {
        background-color: #d1d5db;
    }
    .text-gray-800 {
        color: #2d3748;
    }
    .mr-2 {
        margin-right: 0.5rem;
    }
    .bg-red-100 {
        background-color: #fed7d7;
    }
    .border-red-400 {
        border-color: #f56565;
    }
    .text-red-700 {
        color: #c53030;
    }
    .px-4 {
        padding-left: 1rem;
        padding-right: 1rem;
    }
    .py-3 {
        padding-top: 0.75rem;
        padding-bottom: 0.75rem;
    }
    .rounded {
        border-radius: 0.25rem;
    }
    .mb-4 {
        margin-bottom: 1rem;
    }
    .bg-yellow-100 {
        background-color: #feebc8;
    }
    .border-yellow-400 {
        border-color: #f6ad55;
    }
    .text-yellow-700 {
        color: #b7791f;
    }
    .flex-col {
        flex-direction: column;
    }
    .items-center {
        align-items: center;
    }
    .object-cover {
        object-fit: cover;
    }
    .text-4xl {
        font-size: 2.25rem;
    }
    .text-gray-400 {
        color: #9ca3af;
    }
    
    /* Additional styles for form layout */
    .form-section {
        margin-bottom: 25px;
        padding-bottom: 20px;
        border-bottom: 1px solid #eaeaea;
    }
    
 
    
    .section-title i {
        margin-right: 10px;
    }
    
    .form-row {
        display: flex;
        flex-wrap: wrap;
        margin: 0 -10px 15px;
    }
    
    .form-group {
        flex: 1 0 300px;
        padding: 0 10px;
        margin-bottom: 15px;
    }
    
    .required::after {
        content: " *";
        color: #e22;
    }
    
    .photo-upload {
        display: flex;
        flex-direction: column;
        align-items: center;
        margin-top: 10px;
    }
    
    .photo-preview {
        width: 120px;
        height: 120px;
        border: 2px dashed #d1d5db;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 15px;
        overflow: hidden;
    }
    
    .photo-preview img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        display: none;
    }
    
    .upload-btn {
        background: #eff6ff;
        color: #2563eb;
        border: 1px solid #2563eb;
        padding: 8px 20px;
        border-radius: 5px;
        cursor: pointer;
        transition: all 0.3s;
    }
    
    .upload-btn:hover {
        background: #2563eb;
        color: white;
    }
    
    .alert {
        padding: 15px;
        margin: 20px 0;
        border-radius: 5px;
        text-align: center;
    }
    
    .alert-success {
        background-color: #d1fae5;
        color: #065f46;
        border: 1px solid #a7f3d0;
    }
    
    .alert-error {
        background-color: #fee2e2;
        color: #991b1b;
        border: 1px solid #fecaca;
    }
    
    .checkbox-group {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        margin-top: 8px;
    }
    
    .checkbox-item {
        display: flex;
        align-items: center;
        margin-right: 15px;
    }
    
    .checkbox-item input {
        width: auto;
        margin-right: 5px;
    }
    
    @media (max-width: 768px) {
        .form-group {
            flex: 1 0 100%;
        }
        
        .checkbox-group {
            flex-direction: column;
            gap: 5px;
        }
    }
</style>

<div class="bg-white p-6  ">
    <h2 class="text-2xl font-bold text-gray-800 mb-6">Add New Teacher</h2>
    
    <?php if (!empty($success)): ?>
        <div class="alert alert-success"><?php echo $success; ?></div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="alert alert-error"><?php echo $error; ?></div>
    <?php endif; ?>
    
    <form id="teacherForm" method="POST" enctype="multipart/form-data" class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- Photo Upload Section -->
        <div class="md:col-span-2 flex flex-col items-center mb-4">
            <div class="relative w-32 h-32 rounded-full overflow-hidden border-4 border-gray-300 mb-4">
                <img id="previewImg" src="" alt="Teacher Photo" class="w-full h-full object-cover hidden">
                <div id="placeholder" class="w-full h-full bg-gray-200 flex items-center justify-center">
                    <i class="fas fa-user text-gray-400 text-4xl"></i>
                </div>
            </div>
            <input type="file" id="photo" name="photo" accept="image/*" class="hidden" onchange="previewImage()">
            <button type="button" onclick="document.getElementById('photo').click()" class="bg-gray-200 hover:bg-gray-300 text-gray-800 px-4 py-2 rounded">
                <i class="fas fa-upload mr-2"></i> Upload Photo
            </button>
        </div>
        
        <!-- Account Information Section -->
        <div class="md:col-span-2">
            <div class="section-title">
                <i class="fas fa-user-circle"></i> Account Information
            </div>
        </div>
        
        <div class="form-group">
            <label for="username" class="block text-gray-700 mb-2 required">Username</label>
            <input type="text" id="username" name="username" value="<?php echo isset($_POST['username']) ? htmlspecialchars($_POST['username']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="password" class="block text-gray-700 mb-2 required">Password</label>
            <input type="password" id="password" name="password" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required onkeyup="validatePassword()">
        </div>
        
        <div class="form-group">
            <label for="confirm_password" class="block text-gray-700 mb-2 required">Confirm Password</label>
            <input type="password" id="confirm_password" name="confirm_password" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required onkeyup="validatePassword()">
            <p id="passwordMessage" class="text-red-500 text-sm mt-1 hidden">Passwords do not match</p>
        </div>
        
        <!-- Personal Information Section -->
        <div class="md:col-span-2">
            <div class="section-title">
                <i class="fas fa-user"></i> Personal Information
            </div>
        </div>
        
        <div class="form-group">
            <label for="fullName" class="block text-gray-700 mb-2 required">Full Name</label>
            <input type="text" id="fullName" name="fullName" value="<?php echo isset($_POST['fullName']) ? htmlspecialchars($_POST['fullName']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="dob" class="block text-gray-700 mb-2 required">Date of Birth</label>
            <input type="date" id="dob" name="dob" value="<?php echo isset($_POST['dob']) ? htmlspecialchars($_POST['dob']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="gender" class="block text-gray-700 mb-2 required">Gender</label>
            <select id="gender" name="gender" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                <option value="">Select Gender</option>
                <option value="male" <?php echo (isset($_POST['gender']) && $_POST['gender'] == 'male') ? 'selected' : ''; ?>>Male</option>
                <option value="female" <?php echo (isset($_POST['gender']) && $_POST['gender'] == 'female') ? 'selected' : ''; ?>>Female</option>
                <option value="other" <?php echo (isset($_POST['gender']) && $_POST['gender'] == 'other') ? 'selected' : ''; ?>>Other</option>
            </select>
        </div>
        
        <div class="form-group">
            <label for="nationality" class="block text-gray-700 mb-2">Nationality</label>
            <input type="text" id="nationality" name="nationality" value="<?php echo isset($_POST['nationality']) ? htmlspecialchars($_POST['nationality']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <div class="form-group">
            <label for="idNumber" class="block text-gray-700 mb-2">Government ID Number</label>
            <input type="text" id="idNumber" name="idNumber" value="<?php echo isset($_POST['idNumber']) ? htmlspecialchars($_POST['idNumber']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <!-- Contact Information Section -->
        <div class="md:col-span-2">
            <div class="section-title">
                <i class="fas fa-address-book"></i> Contact Information
            </div>
        </div>
        
        <div class="md:col-span-2 form-group">
            <label for="address" class="block text-gray-700 mb-2 required">Residential Address</label>
            <textarea id="address" name="address" rows="3" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required><?php echo isset($_POST['address']) ? htmlspecialchars($_POST['address']) : ''; ?></textarea>
        </div>
        
        <div class="form-group">
            <label for="phone" class="block text-gray-700 mb-2 required">Phone Number</label>
            <input type="tel" id="phone" name="phone" value="<?php echo isset($_POST['phone']) ? htmlspecialchars($_POST['phone']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="email" class="block text-gray-700 mb-2 required">Email Address</label>
            <input type="email" id="email" name="email" value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="emergencyContact" class="block text-gray-700 mb-2">Emergency Contact Person</label>
            <input type="text" id="emergencyContact" name="emergencyContact" value="<?php echo isset($_POST['emergencyContact']) ? htmlspecialchars($_POST['emergencyContact']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <div class="form-group">
            <label for="emergencyPhone" class="block text-gray-700 mb-2">Emergency Contact Phone</label>
            <input type="tel" id="emergencyPhone" name="emergencyPhone" value="<?php echo isset($_POST['emergencyPhone']) ? htmlspecialchars($_POST['emergencyPhone']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <!-- Professional Information Section -->
        <div class="md:col-span-2">
            <div class="section-title">
                <i class="fas fa-briefcase"></i> Professional Information
            </div>
        </div>
        
        <div class="form-group">
            <label for="hireDate" class="block text-gray-700 mb-2 required">Hire Date</label>
            <input type="date" id="hireDate" name="hireDate" value="<?php echo isset($_POST['hireDate']) ? htmlspecialchars($_POST['hireDate']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        
        
       
        
        <div class="form-group">
            <label for="highestDegree" class="block text-gray-700 mb-2 required">Highest Degree</label>
            <input type="text" id="highestDegree" name="highestDegree" value="<?php echo isset($_POST['highestDegree']) ? htmlspecialchars($_POST['highestDegree']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="university" class="block text-gray-700 mb-2 required">University/Institution</label>
            <input type="text" id="university" name="university" value="<?php echo isset($_POST['university']) ? htmlspecialchars($_POST['university']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="graduationYear" class="block text-gray-700 mb-2 required">Year of Graduation</label>
            <input type="number" id="graduationYear" name="graduationYear" min="1950" max="<?php echo date('Y'); ?>" value="<?php echo isset($_POST['graduationYear']) ? htmlspecialchars($_POST['graduationYear']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="experience" class="block text-gray-700 mb-2 required">Years of Experience</label>
            <input type="number" id="experience" name="experience" min="0" value="<?php echo isset($_POST['experience']) ? htmlspecialchars($_POST['experience']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="salary" class="block text-gray-700 mb-2 required">Salary</label>
            <input type="number" id="salary" name="salary" min="0" step="0.01" value="<?php echo isset($_POST['salary']) ? htmlspecialchars($_POST['salary']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="bankAccount" class="block text-gray-700 mb-2">Bank Account Number</label>
            <input type="text" id="bankAccount" name="bankAccount" value="<?php echo isset($_POST['bankAccount']) ? htmlspecialchars($_POST['bankAccount']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <div class="form-group">
            <label for="bankName" class="block text-gray-700 mb-2">Bank Name</label>
            <input type="text" id="bankName" name="bankName" value="<?php echo isset($_POST['bankName']) ? htmlspecialchars($_POST['bankName']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <!-- Medical Information Section -->
        <div class="md:col-span-2">
            <div class="section-title">
                <i class="fas fa-heartbeat"></i> Medical Information
            </div>
        </div>
        
        <div class="md:col-span-2 form-group">
            <label for="medicalConditions" class="block text-gray-700 mb-2">Medical Conditions</label>
            <textarea id="medicalConditions" name="medicalConditions" rows="2" placeholder="e.g., Asthma, Diabetes" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500"><?php echo isset($_POST['medicalConditions']) ? htmlspecialchars($_POST['medicalConditions']) : ''; ?></textarea>
        </div>
        
        <div class="form-group">
            <label for="allergies" class="block text-gray-700 mb-2">Allergies</label>
            <input type="text" id="allergies" name="allergies" placeholder="e.g., Peanuts, Dust" value="<?php echo isset($_POST['allergies']) ? htmlspecialchars($_POST['allergies']) : ''; ?>" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <div class="form-group">
            <label for="bloodGroup" class="block text-gray-700 mb-2">Blood Group</label>
            <select id="bloodGroup" name="bloodGroup" class="w-full px-4 py-2 border  focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="">Select Blood Group</option>
                <option value="A+" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'A+') ? 'selected' : ''; ?>>A+</option>
                <option value="A-" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'A-') ? 'selected' : ''; ?>>A-</option>
                <option value="B+" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'B+') ? 'selected' : ''; ?>>B+</option>
                <option value="B-" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'B-') ? 'selected' : ''; ?>>B-</option>
                <option value="AB+" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'AB+') ? 'selected' : ''; ?>>AB+</option>
                <option value="AB-" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'AB-') ? 'selected' : ''; ?>>AB-</option>
                <option value="O+" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'O+') ? 'selected' : ''; ?>>O+</option>
                <option value="O-" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'O-') ? 'selected' : ''; ?>>O-</option>
            </select>
        </div>
        
        <div class="md:col-span-2 flex justify-end space-x-4 mt-4">
            <a href="add_teacher.php" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-2 ">Cancel</a>
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 ">
                Add Teacher
            </button>
        </div>
    </form>
</div>

<script>
    // Photo preview functionality
    function previewImage() {
        const file = document.getElementById('photo').files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                const previewImg = document.getElementById('previewImg');
                previewImg.src = e.target.result;
                previewImg.classList.remove('hidden');
                document.getElementById('placeholder').classList.add('hidden');
            }
            reader.readAsDataURL(file);
        }
    }
    
    // Password validation
    function validatePassword() {
        const password = document.getElementById('password').value;
        const confirmPassword = document.getElementById('confirm_password').value;
        const message = document.getElementById('passwordMessage');
        
        if (password !== confirmPassword && confirmPassword !== '') {
            message.classList.remove('hidden');
        } else {
            message.classList.add('hidden');
        }
    }
    
    // Add event listeners for password validation
    document.getElementById('password').addEventListener('keyup', validatePassword);
    document.getElementById('confirm_password').addEventListener('keyup', validatePassword);
    
    // Form validation before submission
    document.getElementById('teacherForm').addEventListener('submit', function(e) {
        const password = document.getElementById('password').value;
        const confirmPassword = document.getElementById('confirm_password').value;
        
        if (password !== confirmPassword) {
            e.preventDefault();
            alert('Passwords do not match. Please correct and try again.');
            return false;
        }
    });
</script>

<?php include 'include/footer.php'; ?>