<?php
include 'include/header.php';
include '../config/conn.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$admin_id = $_SESSION['user_id'];
$admin_name = $_SESSION['user_name'];

$success = '';
$error = '';

// Fetch classes from database
$classes = [];
$class_query = "SELECT `id`, `class_name` FROM `classes` WHERE `status` = 'active'";
$class_result = mysqli_query($conn, $class_query);
if ($class_result && mysqli_num_rows($class_result) > 0) {
    while ($row = mysqli_fetch_assoc($class_result)) {
        $classes[$row['id']] = $row['class_name'];
    }
}

// Fetch sections from database
$sections = [];
$section_query = "SELECT `id`, `section_name`, `class_id` FROM `sections` WHERE `status` = 'active'";
$section_result = mysqli_query($conn, $section_query);
if ($section_result && mysqli_num_rows($section_result) > 0) {
    while ($row = mysqli_fetch_assoc($section_result)) {
        if (!isset($sections[$row['class_id']])) {
            $sections[$row['class_id']] = [];
        }
        $sections[$row['class_id']][$row['id']] = $row['section_name'];
    }
}

// Fetch parents from database
$parents = [];
$parent_query = "SELECT `id`, `fullname`, `username`, `email` FROM `parents` ORDER BY `fullname`";
$parent_result = mysqli_query($conn, $parent_query);
if ($parent_result && mysqli_num_rows($parent_result) > 0) {
    while ($row = mysqli_fetch_assoc($parent_result)) {
        $parents[$row['id']] = $row['fullname'] . ' (' . $row['email'] . ')';
    }
}

// Function to safely get POST values
function getPostValue($key) {
    return isset($_POST[$key]) ? mysqli_real_escape_string($GLOBALS['conn'], $_POST[$key]) : '';
}

// Function to check if email already exists
function emailExists($email, $conn) {
    $email = mysqli_real_escape_string($conn, $email);
    $sql = "SELECT student_id FROM students WHERE email = '$email'";
    $result = mysqli_query($conn, $sql);
    return mysqli_num_rows($result) > 0;
}

// Function to check if username already exists
function usernameExists($username, $conn) {
    $username = mysqli_real_escape_string($conn, $username);
    $sql = "SELECT student_id FROM students WHERE username = '$username'";
    $result = mysqli_query($conn, $sql);
    return mysqli_num_rows($result) > 0;
}

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Handle regular form submission using the safe function
    $fullName = getPostValue('fullName');
    $username = getPostValue('username');
    $password = getPostValue('password');
    $confirm_password = getPostValue('confirm_password');
    $dob = getPostValue('dob');
    $gender = getPostValue('gender');
    $nationality = getPostValue('nationality');
    $idNumber = getPostValue('idNumber');
    $address = getPostValue('address');
    $phone = getPostValue('phone');
    $email = getPostValue('email');
    $emergencyContact = getPostValue('emergencyContact');
    $emergencyPhone = getPostValue('emergencyPhone');
    $admissionDate = getPostValue('admissionDate');
    $class = getPostValue('class');
    $section = getPostValue('section');
    $rollNumber = getPostValue('rollNumber');
    $previousSchool = getPostValue('previousSchool');
    $previousGrades = getPostValue('previousGrades');
    $medicalConditions = getPostValue('medicalConditions');
    $allergies = getPostValue('allergies');
    $bloodGroup = getPostValue('bloodGroup');
    $parent_id = getPostValue('parent_id');
    
    // Validate required fields
    if (empty($fullName) || empty($username) || empty($password) || empty($confirm_password) || 
        empty($dob) || empty($gender) || empty($address) || empty($phone) || empty($email) || 
        empty($admissionDate) || empty($class) || empty($section) || empty($rollNumber) || 
        empty($parent_id)) {
        $error = "Please fill in all required fields.";
    } 
    // Check if passwords match
    else if ($password !== $confirm_password) {
        $error = "Passwords do not match.";
    }
    // Check if email already exists
    else if (emailExists($email, $conn)) {
        $error = "A student with this email address already exists. Please use a different email.";
    }
    // Check if username already exists
    else if (usernameExists($username, $conn)) {
        $error = "Username already exists. Please choose a different username.";
    }
    else {
        // Handle file upload
        $photoPath = '';
        if (isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
            $targetDir = "../uploads/";
            if (!is_dir($targetDir)) {
                mkdir($targetDir, 0777, true);
            }
            
            $fileName = time() . '_' . basename($_FILES['photo']['name']);
            $targetFilePath = $targetDir . $fileName;
            $fileType = pathinfo($targetFilePath, PATHINFO_EXTENSION);
            
            // Allow certain file formats
            $allowTypes = array('jpg', 'png', 'jpeg', 'gif');
            if (in_array($fileType, $allowTypes)) {
                if (move_uploaded_file($_FILES['photo']['tmp_name'], $targetFilePath)) {
                    $photoPath = $targetFilePath;
                }
            }
        }
        
        // Generate a unique student ID
        $studentId = 'ADINO' . date('Y') . rand(1000, 9999);
        
        // Hash the password
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        
        // Insert into database with admin info
        $sql = "INSERT INTO students (
            student_id, username, password, full_name, dob, gender, nationality, id_number, photo, 
            address, phone, email, emergency_contact, emergency_phone, 
            admission_date, class, section, roll_number, previous_school, previous_grades,
            medical_conditions, allergies, blood_group, parent_id, created_by
        ) VALUES (
            '$studentId', '$username', '$hashed_password', '$fullName', '$dob', '$gender', '$nationality', '$idNumber', '$photoPath',
            '$address', '$phone', '$email', '$emergencyContact', '$emergencyPhone',
            '$admissionDate', '$class', '$section', '$rollNumber', '$previousSchool', '$previousGrades',
            '$medicalConditions', '$allergies', '$bloodGroup', '$parent_id', '$admin_id'
        )";
        
        if (mysqli_query($conn, $sql)) {
            $success = "Student registered successfully! Student ID: " . $studentId . 
                       " (Added by " . $admin_name . " at " . date('Y-m-d H:i:s') . ")";
            
            // Clear form fields after successful submission
            echo '<script>
                document.addEventListener("DOMContentLoaded", function() {
                    document.getElementById("studentForm").reset();
                    document.getElementById("previewImg").style.display = "none";
                    document.querySelector(".photo-preview i").style.display = "block";
                });
            </script>';
        } else {
            $error = "Error: " . mysqli_error($conn);
        }
    }
}
?>

<style>
    .bg-white {
        background-color: white;
    }
    .p-6 {
        padding: 1.5rem;
    }
    
   
    .text-2xl {
        font-size: 1.5rem;
    }
    .font-bold {
        font-weight: 700;
    }
    .text-gray-800 {
        color: #2d3748;
    }
    .mb-6 {
        margin-bottom: 1.5rem;
    }
    .grid {
        display: grid;
    }
    .grid-cols-1 {
        grid-template-columns: repeat(1, minmax(0, 1fr));
    }
    .md\:grid-cols-2 {
        grid-template-columns: repeat(2, minmax(0, 1fr));
    }
    .gap-6 {
        gap: 1.5rem;
    }
    .block {
        display: block;
    }
    .text-gray-700 {
        color: #4a5568;
    }
    .mb-2 {
        margin-bottom: 0.5rem;
    }
    .w-full {
        width: 100%;
    }
    .px-4 {
        padding-left: 1rem;
        padding-right: 1rem;
    }
    .py-2 {
        padding-top: 0.5rem;
        padding-bottom: 0.5rem;
    }
    .border {
        border-width: 1px;
    }
    .{
        border-radius: 0.5rem;
    }
    .focus\:outline-none:focus {
        outline: none;
    }
    .focus\:ring-2:focus {
        box-shadow: 0 0 0 2px rgba(66, 153, 225, 0.5);
    }
    .focus\:ring-blue-500:focus {
        --tw-ring-color: #4299e1;
    }
    .md\:col-span-2 {
        grid-column: span 2 / span 2;
    }
    .flex {
        display: flex;
    }
    .justify-end {
        justify-content: flex-end;
    }
    .space-x-4 > * + * {
        margin-left: 1rem;
    }
    .mt-4 {
        margin-top: 1rem;
    }
    .bg-gray-500 {
        background-color: #6b7280;
    }
    .hover\:bg-gray-600:hover {
        background-color: #4b5563;
    }
    .text-white {
        color: white;
    }
    .px-6 {
        padding-left: 1.5rem;
        padding-right: 1.5rem;
    }
    .py-2 {
        padding-top: 0.5rem;
        padding-bottom: 0.5rem;
    }
   
    .hover\:bg-blue-700:hover {
        background-color: #1d4ed8;
    }
    .relative {
        position: relative;
    }
    .w-32 {
        width: 8rem;
    }
    .h-32 {
        height: 8rem;
    }
   
    .overflow-hidden {
        overflow: hidden;
    }
    .border-4 {
        border-width: 4px;
    }
    .border-gray-300 {
        border-color: #d1d5db;
    }
   
    .bg-gray-200 {
        background-color: #e5e7eb;
    }
    .hover\:bg-gray-300:hover {
        background-color: #d1d5db;
    }
    .text-gray-800 {
        color: #2d3748;
    }
    .mr-2 {
        margin-right: 0.5rem;
    }
    .bg-red-100 {
        background-color: #fed7d7;
    }
    .border-red-400 {
        border-color: #f56565;
    }
    .text-red-700 {
        color: #c53030;
    }
    .px-4 {
        padding-left: 1rem;
        padding-right: 1rem;
    }
    .py-3 {
        padding-top: 0.75rem;
        padding-bottom: 0.75rem;
    }
    .rounded {
        border-radius: 0.25rem;
    }
    .mb-4 {
        margin-bottom: 1rem;
    }
    .bg-yellow-100 {
        background-color: #feebc8;
    }
    .border-yellow-400 {
        border-color: #f6ad55;
    }
    .text-yellow-700 {
        color: #b7791f;
    }
    .flex-col {
        flex-direction: column;
    }
    .items-center {
        align-items: center;
    }
    .object-cover {
        object-fit: cover;
    }
    .text-4xl {
        font-size: 2.25rem;
    }
    .text-gray-400 {
        color: #9ca3af;
    }
    
    /* Additional styles for form layout */
    .form-section {
        margin-bottom: 25px;
        padding-bottom: 20px;
        border-bottom: 1px solid #eaeaea;
    }
    
 
    .section-title i {
        margin-right: 10px;
    }
    
    .form-row {
        display: flex;
        flex-wrap: wrap;
        margin: 0 -10px 15px;
    }
    
    .form-group {
        flex: 1 0 300px;
        padding: 0 10px;
        margin-bottom: 15px;
    }
    
    .required::after {
        content: " *";
        color: #e22;
    }
    
    .photo-upload {
        display: flex;
        flex-direction: column;
        align-items: center;
        margin-top: 10px;
    }
    
    .photo-preview {
        width: 120px;
        height: 120px;
        border: 2px dashed #d1d5db;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 15px;
        overflow: hidden;
    }
    
    .photo-preview img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        display: none;
    }
    
    .upload-btn {
        background: #eff6ff;
        color: #2563eb;
        border: 1px solid #2563eb;
        padding: 8px 20px;
        border-radius: 5px;
        cursor: pointer;
        transition: all 0.3s;
    }
    
    .upload-btn:hover {
        background: #2563eb;
        color: white;
    }
    
    .alert {
        padding: 15px;
        margin: 20px 0;
        border-radius: 5px;
        text-align: center;
    }
    
    .alert-success {
        background-color: #d1fae5;
        color: #065f46;
        border: 1px solid #a7f3d0;
    }
    
    .alert-error {
        background-color: #fee2e2;
        color: #991b1b;
        border: 1px solid #fecaca;
    }
    
    @media (max-width: 768px) {
        .form-group {
            flex: 1 0 100%;
        }
    }
</style>

<div class="bg-white p-6 ">
    <h2 class="text-2xl font-bold text-gray-800 mb-6">Add New Student</h2>
    
    <?php if (!empty($success)): ?>
        <div class="alert alert-success"><?php echo $success; ?></div>
    <?php endif; ?>
    
    <?php if (!empty($error)): ?>
        <div class="alert alert-error"><?php echo $error; ?></div>
    <?php endif; ?>
    
    <form id="studentForm" method="POST" enctype="multipart/form-data" class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- Photo Upload Section -->
        <div class="md:col-span-2 flex flex-col items-center mb-4">
            <div class="relative w-32 h-32 rounded-full overflow-hidden border-4 border-gray-300 mb-4">
                <img id="previewImg" src="" alt="Student Photo" class="w-full h-full object-cover hidden">
                <div id="placeholder" class="w-full h-full bg-gray-200 flex items-center justify-center">
                    <i class="fas fa-user text-gray-400 text-4xl"></i>
                </div>
            </div>
            <input type="file" id="photo" name="photo" accept="image/*" class="hidden" onchange="previewImage()">
            <button type="button" onclick="document.getElementById('photo').click()" class="bg-gray-200 hover:bg-gray-300 text-gray-800 px-4 py-2 rounded">
                <i class="fas fa-upload mr-2"></i> Upload Photo
            </button>
        </div>
        
        <!-- Account Information Section -->
        <div class="md:col-span-2">
            <div class="section-title">
                <i class="fas fa-user-circle"></i> Account Information
            </div>
        </div>
        
        <div class="form-group">
            <label for="username" class="block text-gray-700 mb-2 required">Username</label>
            <input type="text" id="username" name="username" value="<?php echo isset($_POST['username']) ? htmlspecialchars($_POST['username']) : ''; ?>" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="password" class="block text-gray-700 mb-2 required">Password</label>
            <input type="password" id="password" name="password" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" required onkeyup="validatePassword()">
        </div>
        
        <div class="form-group">
            <label for="confirm_password" class="block text-gray-700 mb-2 required">Confirm Password</label>
            <input type="password" id="confirm_password" name="confirm_password" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" required onkeyup="validatePassword()">
            <p id="passwordMessage" class="text-red-500 text-sm mt-1 hidden">Passwords do not match</p>
        </div>
        
        <div class="form-group">
            <label for="parent_id" class="block text-gray-700 mb-2 required">Select Parent</label>
            <select id="parent_id" name="parent_id" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                <option value="">Select Parent</option>
                <?php foreach ($parents as $id => $name): ?>
                    <option value="<?php echo $id; ?>" <?php echo (isset($_POST['parent_id']) && $_POST['parent_id'] == $id) ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($name); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <!-- Personal Information Section -->
        <div class="md:col-span-2">
            <div class="section-title">
                <i class="fas fa-user"></i> Personal Information
            </div>
        </div>
        
        <div class="form-group">
            <label for="fullName" class="block text-gray-700 mb-2 required">Full Name</label>
            <input type="text" id="fullName" name="fullName" value="<?php echo isset($_POST['fullName']) ? htmlspecialchars($_POST['fullName']) : ''; ?>" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="dob" class="block text-gray-700 mb-2 required">Date of Birth</label>
            <input type="date" id="dob" name="dob" value="<?php echo isset($_POST['dob']) ? htmlspecialchars($_POST['dob']) : ''; ?>" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="gender" class="block text-gray-700 mb-2 required">Gender</label>
            <select id="gender" name="gender" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                <option value="">Select Gender</option>
                <option value="male" <?php echo (isset($_POST['gender']) && $_POST['gender'] == 'male') ? 'selected' : ''; ?>>Male</option>
                <option value="female" <?php echo (isset($_POST['gender']) && $_POST['gender'] == 'female') ? 'selected' : ''; ?>>Female</option>
                <option value="other" <?php echo (isset($_POST['gender']) && $_POST['gender'] == 'other') ? 'selected' : ''; ?>>Other</option>
            </select>
        </div>
        
        <div class="form-group">
            <label for="nationality" class="block text-gray-700 mb-2">Nationality</label>
            <input type="text" id="nationality" name="nationality" value="<?php echo isset($_POST['nationality']) ? htmlspecialchars($_POST['nationality']) : ''; ?>" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <div class="form-group">
            <label for="idNumber" class="block text-gray-700 mb-2">Government ID Number</label>
            <input type="text" id="idNumber" name="idNumber" value="<?php echo isset($_POST['idNumber']) ? htmlspecialchars($_POST['idNumber']) : ''; ?>" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <!-- Contact Information Section -->
        <div class="md:col-span-2">
            <div class="section-title">
                <i class="fas fa-address-book"></i> Contact Information
            </div>
        </div>
        
        <div class="md:col-span-2 form-group">
            <label for="address" class="block text-gray-700 mb-2 required">Residential Address</label>
            <textarea id="address" name="address" rows="3" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" required><?php echo isset($_POST['address']) ? htmlspecialchars($_POST['address']) : ''; ?></textarea>
        </div>
        
        <div class="form-group">
            <label for="phone" class="block text-gray-700 mb-2 required">Phone Number</label>
            <input type="tel" id="phone" name="phone" value="<?php echo isset($_POST['phone']) ? htmlspecialchars($_POST['phone']) : ''; ?>" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="email" class="block text-gray-700 mb-2 required">Email Address</label>
            <input type="email" id="email" name="email" value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="emergencyContact" class="block text-gray-700 mb-2">Emergency Contact Person</label>
            <input type="text" id="emergencyContact" name="emergencyContact" value="<?php echo isset($_POST['emergencyContact']) ? htmlspecialchars($_POST['emergencyContact']) : ''; ?>" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <div class="form-group">
            <label for="emergencyPhone" class="block text-gray-700 mb-2">Emergency Contact Phone</label>
            <input type="tel" id="emergencyPhone" name="emergencyPhone" value="<?php echo isset($_POST['emergencyPhone']) ? htmlspecialchars($_POST['emergencyPhone']) : ''; ?>" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <!-- Academic Information Section -->
        <div class="md:col-span-2">
            <div class="section-title">
                <i class="fas fa-graduation-cap"></i> Academic Information
            </div>
        </div>
        
        <div class="form-group">
            <label for="admissionDate" class="block text-gray-700 mb-2 required">Admission Date</label>
            <input type="date" id="admissionDate" name="admissionDate" value="<?php echo isset($_POST['admissionDate']) ? htmlspecialchars($_POST['admissionDate']) : ''; ?>" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="class" class="block text-gray-700 mb-2 required">Class</label>
            <select id="class" name="class" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                <option value="">Select Class</option>
                <?php foreach ($classes as $id => $name): ?>
                    <option value="<?php echo $id; ?>" <?php echo (isset($_POST['class']) && $_POST['class'] == $id) ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($name); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div class="form-group">
            <label for="section" class="block text-gray-700 mb-2 required">Section</label>
            <select id="section" name="section" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                <option value="">Select Section</option>
                <?php 
                // Show sections based on selected class (if any)
                $selectedClass = isset($_POST['class']) ? $_POST['class'] : '';
                if ($selectedClass && isset($sections[$selectedClass])) {
                    foreach ($sections[$selectedClass] as $id => $name) {
                        $selected = (isset($_POST['section']) && $_POST['section'] == $id) ? 'selected' : '';
                        echo "<option value='$id' $selected>" . htmlspecialchars($name) . "</option>";
                    }
                }
                ?>
            </select>
        </div>
        
        <div class="form-group">
            <label for="rollNumber" class="block text-gray-700 mb-2 required">Roll Number</label>
            <input type="text" id="rollNumber" name="rollNumber" value="<?php echo isset($_POST['rollNumber']) ? htmlspecialchars($_POST['rollNumber']) : ''; ?>" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>
        
        <div class="form-group">
            <label for="previousSchool" class="block text-gray-700 mb-2">Previous School (if any)</label>
            <input type="text" id="previousSchool" name="previousSchool" value="<?php echo isset($_POST['previousSchool']) ? htmlspecialchars($_POST['previousSchool']) : ''; ?>" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <div class="form-group">
            <label for="previousGrades" class="block text-gray-700 mb-2">Previous Grades/Percentage</label>
            <input type="text" id="previousGrades" name="previousGrades" value="<?php echo isset($_POST['previousGrades']) ? htmlspecialchars($_POST['previousGrades']) : ''; ?>" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <!-- Medical Information Section -->
        <div class="md:col-span-2">
            <div class="section-title">
                <i class="fas fa-heartbeat"></i> Medical Information
            </div>
        </div>
        
        <div class="md:col-span-2 form-group">
            <label for="medicalConditions" class="block text-gray-700 mb-2">Medical Conditions</label>
            <textarea id="medicalConditions" name="medicalConditions" rows="2" placeholder="e.g., Asthma, Diabetes" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500"><?php echo isset($_POST['medicalConditions']) ? htmlspecialchars($_POST['medicalConditions']) : ''; ?></textarea>
        </div>
        
        <div class="form-group">
            <label for="allergies" class="block text-gray-700 mb-2">Allergies</label>
            <input type="text" id="allergies" name="allergies" placeholder="e.g., Peanuts, Dust" value="<?php echo isset($_POST['allergies']) ? htmlspecialchars($_POST['allergies']) : ''; ?>" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <div class="form-group">
            <label for="bloodGroup" class="block text-gray-700 mb-2">Blood Group</label>
            <select id="bloodGroup" name="bloodGroup" class="w-full px-4 py-2 border focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="">Select Blood Group</option>
                <option value="A+" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'A+') ? 'selected' : ''; ?>>A+</option>
                <option value="A-" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'A-') ? 'selected' : ''; ?>>A-</option>
                <option value="B+" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'B+') ? 'selected' : ''; ?>>B+</option>
                <option value="B-" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'B-') ? 'selected' : ''; ?>>B-</option>
                <option value="AB+" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'AB+') ? 'selected' : ''; ?>>AB+</option>
                <option value="AB-" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'AB-') ? 'selected' : ''; ?>>AB-</option>
                <option value="O+" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'O+') ? 'selected' : ''; ?>>O+</option>
                <option value="O-" <?php echo (isset($_POST['bloodGroup']) && $_POST['bloodGroup'] == 'O-') ? 'selected' : ''; ?>>O-</option>
            </select>
        </div>
        
        <div class="md:col-span-2 flex justify-end space-x-4 mt-4">
            <a href="students.php" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-2 ">Cancel</a>
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 ">
                Add Student
            </button>
        </div>
    </form>
</div>

<script>
    // Photo preview functionality
   // Photo preview functionality
function previewImage() {
    const file = document.getElementById('photo').files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const previewImg = document.getElementById('previewImg');
            previewImg.src = e.target.result;
            previewImg.classList.remove('hidden');
            document.getElementById('placeholder').classList.add('hidden');
        }
        reader.readAsDataURL(file);
    }
}

// Dynamic section loading based on class selection
document.getElementById('class').addEventListener('change', function() {
    const classId = this.value;
    const sectionSelect = document.getElementById('section');
    
    // Clear existing options
    sectionSelect.innerHTML = '<option value="">Select Section</option>';
    
    if (classId) {
        // Show loading state
        const loadingOption = document.createElement('option');
        loadingOption.value = '';
        loadingOption.textContent = 'Loading sections...';
        loadingOption.disabled = true;
        sectionSelect.appendChild(loadingOption);
        
        // AJAX request to fetch sections for the selected class
        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'get_sections.php', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                // Clear loading state
                sectionSelect.innerHTML = '<option value="">Select Section</option>';
                
                if (xhr.status === 200) {
                    try {
                        const sections = JSON.parse(xhr.responseText);
                        if (sections.length > 0) {
                            sections.forEach(function(section) {
                                const option = document.createElement('option');
                                option.value = section.id;
                                option.textContent = section.name;
                                sectionSelect.appendChild(option);
                            });
                        } else {
                            const option = document.createElement('option');
                            option.value = '';
                            option.textContent = 'No sections available';
                            option.disabled = true;
                            sectionSelect.appendChild(option);
                        }
                    } catch (e) {
                        console.error('Error parsing sections:', e);
                        const option = document.createElement('option');
                        option.value = '';
                        option.textContent = 'Error loading sections';
                        option.disabled = true;
                        sectionSelect.appendChild(option);
                    }
                } else {
                    const option = document.createElement('option');
                    option.value = '';
                    option.textContent = 'Error loading sections';
                    option.disabled = true;
                    sectionSelect.appendChild(option);
                }
            }
        };
        xhr.onerror = function() {
            sectionSelect.innerHTML = '<option value="">Select Section</option>';
            const option = document.createElement('option');
            option.value = '';
            option.textContent = 'Error loading sections';
            option.disabled = true;
            sectionSelect.appendChild(option);
        };
        xhr.send('class_id=' + classId);
    }
});

// Trigger change event on page load if a class is already selected
document.addEventListener('DOMContentLoaded', function() {
    const selectedClass = document.getElementById('class').value;
    if (selectedClass) {
        // Create a small delay to ensure the DOM is fully loaded
        setTimeout(function() {
            document.getElementById('class').dispatchEvent(new Event('change'));
        }, 100);
    }
});

// Password validation
function validatePassword() {
    const password = document.getElementById('password').value;
    const confirmPassword = document.getElementById('confirm_password').value;
    const message = document.getElementById('passwordMessage');
    
    if (password !== confirmPassword && confirmPassword !== '') {
        message.classList.remove('hidden');
    } else {
        message.classList.add('hidden');
    }
}

// Add event listeners for password validation
document.getElementById('password').addEventListener('keyup', validatePassword);
document.getElementById('confirm_password').addEventListener('keyup', validatePassword);

// Form validation before submission
document.getElementById('studentForm').addEventListener('submit', function(e) {
    const password = document.getElementById('password').value;
    const confirmPassword = document.getElementById('confirm_password').value;
    
    if (password !== confirmPassword) {
        e.preventDefault();
        alert('Passwords do not match. Please correct and try again.');
        return false;
    }
});
</script>

<?php include 'include/footer.php'; ?>