<?php
session_start();
include '../config/conn.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

// Check if it's an AJAX request
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajax'])) {
    $quiz_id = intval($_POST['quiz_id']);
    $question_text = mysqli_real_escape_string($conn, $_POST['question_text']);
    $question_type = $_POST['question_type'];
    $marks = floatval($_POST['marks']);
    
    if (empty($question_text) || empty($quiz_id)) {
        echo json_encode(['success' => false, 'message' => 'Please enter question text.']);
        exit();
    }
    
    // Insert question
    $insert_question = "INSERT INTO quiz_questions (quiz_id, question_text, question_type, marks, created_at) 
                        VALUES ($quiz_id, '$question_text', '$question_type', $marks, NOW())";
    
    if (mysqli_query($conn, $insert_question)) {
        $question_id = mysqli_insert_id($conn);
        $options = [];
        
        // Handle options based on question type
        if ($question_type === 'multiple_choice') {
            $post_options = $_POST['options'];
            $correct_answer = intval($_POST['correct_answer']);
            
            foreach ($post_options as $index => $option_text) {
                if (!empty(trim($option_text))) {
                    $is_correct = ($index == $correct_answer) ? 1 : 0;
                    $option_text = mysqli_real_escape_string($conn, $option_text);
                    
                    $insert_option = "INSERT INTO quiz_question_options (question_id, option_text, is_correct) 
                                      VALUES ($question_id, '$option_text', $is_correct)";
                    mysqli_query($conn, $insert_option);
                    
                    $options[] = [
                        'option_text' => $option_text,
                        'is_correct' => $is_correct
                    ];
                }
            }
        }
        
        // Get total questions count
        $count_query = "SELECT COUNT(*) as count FROM quiz_questions WHERE quiz_id = $quiz_id";
        $count_result = mysqli_query($conn, $count_query);
        $question_count = mysqli_fetch_assoc($count_result)['count'];
        
        echo json_encode([
            'success' => true,
            'question_text' => $question_text,
            'question_type' => $question_type,
            'marks' => $marks,
            'options' => $options,
            'questionCount' => $question_count
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error adding question: ' . mysqli_error($conn)]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}
?>